<?php 
 
// Load the database configuration file 
include_once 'server.php'; 
 
// Fetch records from database 
$query = $db->query("SELECT clientname,rules,origin,destination,originid,destinationid FROM rules order by id");
 
if($query->num_rows > 0){ 
    $delimiter = ","; 
    $filename = "rules_" . date('Y-m-d') . ".csv"; 
     
    // Create a file pointer 
    $f = fopen('php://memory', 'w'); 
     
    // Set column headers 
    $fields = array('clientname', 'rules', 'source', 'destination', 'originid', 'destinationid'); 
    fputcsv($f, $fields, $delimiter); 
     
    // Output each row of the data, format line as csv and write to file pointer 
    while($row = $query->fetch_assoc()){ 
        $lineData = array($row['clientname'], $row['rules'], $row['origin'], $row['destination'], $row['originid'], $row['destinationid']); 
        fputcsv($f, $lineData, $delimiter); 
    } 
     
    // Move back to beginning of file 
    fseek($f, 0); 
     
    // Set headers to download file rather than displayed 
    header('Content-Type: text/csv'); 
    header('Content-Disposition: attachment; filename="' . $filename . '";'); 
     
    //output all remaining data on a file pointer 
    fpassthru($f); 
} 
else
{
	$delimiter = ",";
	$filename = "rules_" . date('Y-m-d') . ".csv";
  	$f = fopen('php://memory', 'w');

    	$fields = array('No records found');
	fputcsv($f, $fields, $delimiter);
    	fseek($f, 0);

    // Set headers to download file rather than displayed
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '";');

    //output all remaining data on a file pointer
    fpassthru($f);

}
exit; 
 
?>
