<?php 

include __DIR__ . '/vendor/autoload.php';

class GoogleClient
{
	public static function getClient()
	{
		$client = new Google_Client();
	    $client->setApplicationName('CommissionCalculation');
	    $client->setScopes(Google_Service_Drive::DRIVE);
	    $client->setAuthConfig(__DIR__.'/json/credentials.json');
            $client->setRedirectUri('https://marsupial.bandicoot.us/google-drive/auth.php');
	    //$client->setRedirectUri('https://marsupial.bandicoot.us/auth.php');
	    $client->setAccessType('offline');
	    $client->setIncludeGrantedScopes(true);
$client->setApprovalPrompt('force');

	    
	    // Load previously authorized credentials from a file.
	    $token_path = __DIR__.'/json/token.json';
	    if (file_exists($token_path)) {
	        $accessToken = json_decode(file_get_contents($token_path), true);
		$client->setAccessToken($accessToken);
		
		
		if ($client->isAccessTokenExpired()) {
		
		if ($client->getRefreshToken()) {
			file_put_contents($token_path, json_encode($client->getAccessToken()));
			  //  $response = ['success' => 1, 'client' => $client];
			    //return $response;
	    }
	}
	 $response = ['success' => 1, 'client' => $client];
	return $response;

}
		
else
	{
        // Request authorization from the user.
        $authUrl = $client->createAuthUrl();

        $html = "Please Click the below link and authenticate partner@bandicoot.us account<br>";
        $html .= '<a href="'.$authUrl.'">Click Here</a>';
	    $response = ['success' => 0, 'html' => $html];
	    return $response;
	}
}
}
